<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;

class MakeContentTypesAliasable extends Migration
{
    /**
     * @throws Exception
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $contentTypes = InsideSchema::getContentTypes();

        $blacklist = [
            // menus
            'admin_menus',
            'footer_menus',
            'shortcuts_menus',
            'main_menus',
            'tools_menus',

            // categories
            'events_categories',
            'news_categories',
            'tools_categories',
            'news_types',
            'management_modes',
            'p_and_p_categories',
            'p_and_p_types',
            'regional_office_types',

            // system
            'image_styles',
            'comments',
            'users',
        ];

        collect($contentTypes)->diff($blacklist)->each(
            static function (string $contentType) use ($bridge) {
                $bridge->contentTypeUpdate($contentType, ['aliasable' => true]);
            }
        );
    }
}
