<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeskNewslettersComputedStatisticsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('desk_newsletters_computed_statistics')) {
            return;
        }

        Schema::create(
            'desk_newsletters_computed_statistics',
            function (Blueprint $table) {
                $table->dateTime('date_sent');
                $table->char('langcode', 2)->nullable();
                $table->integer('sent');
                $table->integer('viewed');
                $table->integer('clicked');
                $table->integer('unique_clicked');

                $table->index(['date_sent', 'langcode']);
                $table->unique(['date_sent', 'langcode']);
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('desk_newsletters_computed_statistics');
    }
}
