<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLangcodeInDeskNewslettersSentTable extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('desk_newsletters_sent') || Schema::hasColumn('desk_newsletters_sent', 'langcode')) {
            return;
        }

        Schema::table(
            'desk_newsletters_sent',
            function (Blueprint $table) {
                $table->char('langcode', 2)->nullable();
            }
        );
    }

    public function down(): void
    {
        if (!Schema::hasTable('desk_newsletters_sent') || !Schema::hasColumn('desk_newsletters_sent', 'langcode')) {
            return;
        }

        Schema::table(
            'desk_newsletters_sent',
            function (Blueprint $table) {
                $table->dropColumn('langcode');
            }
        );
    }
}
