<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeskNewslettersStatisticsTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'desk_newsletters_statistics',
            function (Blueprint $table) {
                $table->increments('id');
                $table->string('statistic_type');
                $table->dateTime('created_at');
                $table->dateTime('updated_at');

                $table->dateTime('newsletter_date');
                $table->uuid('user_uuid');

                $table->index(['newsletter_date', 'user_uuid']);
            }
        );
    }

    public function down(): void
    {
        Schema::dropIfExists('desk_newsletters_statistics');
    }
}
