<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddStatsExportNotificationType extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => null,
                'action'    => 'statistics_exported',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.desk.statistics.exported.title',
                    'description' => 'notifications.desk.statistics.exported.description',
                    'icon'        => 'statistics',
                    'text'        => 'notifications.desk.statistics.exported.text',
                    'fields' => ['title']
                ]
            ]
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
