<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddRegionalOfficeTypesField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $contentTypes = ['memorandums', 'career_infos'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'regional_office_types', [
                'name' => 'regional_office_types',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Regional office type',
                    'en' => 'Regional office type',
                ],
                'widget' => [
                    'hidden' => true
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['regional_office_types'],
                    'cardinality' => 1,
                ],
            ]);
        }

        $this->finishUp();
    }


    public function down(): void
    {
    }
}
