<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddPAndPLhgUpdatedNotification extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p'),
                'action'    => 'p_and_p_updated_lhg',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.updated_lhg.title',
                    'description' => 'notifications.p_and_p.updated_lhg.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.updated_lhg.text',
                    'fields' => ['title']
                ]
            ]
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
