<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddPAndPCorpoNotificationType extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'type'      => 'system',
                'default'   => false,
                'event'     => null,
                'model'     => type_to_class('p_and_p_regions'),
                'action'    => 'p_and_p_region_changed',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
                'data'      => [
                    'title'       => 'notifications.p_and_p.region_changed.title',
                    'description' => 'notifications.p_and_p.region_changed.description',
                    'icon'        => 'p_and_p',
                    'text'        => 'notifications.p_and_p.region_changed.text',
                    'fields' => ['title']
                ]
            ]
        );
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
