<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Content\Models\Contents\RegionalOffices;
use Inside\Host\Bridge\BridgeContent;
use Inside\Notify\Models\NotificationType;

class AssignRegionContactOnExistingContents extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $contents = PAndPRegions::query()->get();
        $bridge = new BridgeContent();

        foreach ($contents as $content) {
            $bridge->contentDelete('p_and_p_regions', $content->uuid);
        }

        $models = \Inside\Content\Models\Contents\PAndP::query()->where('status', 1)->where('langcode', 'fr')->get();

        $regions = RegionalOffices::query()->where('langcode', 'fr')->get();

        foreach ($models as $model) {
            foreach ($regions as $region) {
                $manager = $region->manager->first();

                $manager = $manager ? [$manager->uuid] : [];

                $bridge->contentInsert('p_and_p_regions', [
                    'langcode' => $model->langcode,
                    'type' => 'node',
                    'bundle' => 'p_and_p_regions',
                    'title' => $model->title . ' : ' . $region->title,
                    'p_and_p' => [$model->uuid],
                    'regional_offices' => [$region->uuid],
                    'contact' => $manager,
                ]);
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
