<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\PAndPRegions;
use Inside\Notify\Models\NotificationType;

class RemovePAndPNotificationTypes extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $types = [
            'p_and_p_region_created',
            'p_and_p_region_assigned',
            'p_and_p_updated',
            'p_and_p_published',
            'p_and_p_email',
            'p_and_p_region_assignee_changed',
            'p_and_p_updated_manager'
        ];

        foreach ($types as $type) {
            NotificationType::query()->where('action', $type)->delete();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    }
}
