<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class AddPoliciesAndProcedures extends Migration
{
    use CreateContentTypes;

    /**
     * @var string[]
     */
    protected $contentTypes = [
        'p_and_p_types',
        'p_and_p_categories',
        'p_and_p',
        'p_and_p_regions'
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__);

        foreach ($this->contentTypes as $contentType) {
            $this->migrateContent($contentType, true);
        }

        $contents = [
            'p_and_p_types' => [
                [
                    'title' => 'Development & Representation',
                    'color' => '#E46C0A'
                ],
                [
                    'title' => 'Joint Venture',
                    'color' => '#2C3E50'
                ]
            ],
            'p_and_p_categories' => [
                [
                    'title' => '1.1 Business Support',
                ],
                [
                    'title' => '1.1.1 Distribution',
                ],
                [
                    'title' => '1.1.2 E-commerce',
                ],
                [
                    'title' => '1.1.3 IT',
                ],
                [
                    'title' => '1.1.4 Marketing',
                ],
                [
                    'title' => '1.1.5 Operations',
                ],
                [
                    'title' => '1.1.6 Revenue Management',
                ],
                [
                    'title' => '1.2 Communication',
                ],
                [
                    'title' => '1.3 Development',
                ],
                [
                    'title' => '1.4 Finance',
                ],
                [
                    'title' => '1.5 Légal',
                ],
                [
                    'title' => '2.1 Communication',
                ],
                [
                    'title' => '2.2 Finance',
                ],
                [
                    'title' => '2.3 Human Resources',
                ],
                [
                    'title' => '2.4 Legal',
                ],
                [
                    'title' => '2.5 Marketing',
                ],
            ],
        ];

        $bridge = new \Inside\Host\Bridge\BridgeContent();

        $languages = list_languages();

        foreach ($contents as $contentType => $values) {
            foreach ($values as $value) {
                $uuid = $bridge->contentInsert($contentType, array_merge($value, [
                    'type' => 'node',
                    'bundle' => $contentType,
                    'langcode' => 'en',
                ]));

                $content = call_user_func(type_to_class($contentType) . '::find', $uuid);

                $bridge->contentInsert($contentType, array_merge($value, [
                    'type' => 'node',
                    'bundle' => $contentType,
                    'langcode' => 'fr',
                    'uuid_host' => $content->uuid_host,
                ]));
            }
        }

        $this->finishUp();
    }

    public function down(): void
    {
        $bridge = new \Inside\Host\Bridge\BridgeContentType();
        foreach ($this->contentTypes as $contentType) {
            $bridge->contentTypeDelete($contentType);
        }
    }
}
