<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class AddDeskAlertsSentTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('desk_alerts_sent')) {
            Schema::create('desk_alerts_sent', function (Blueprint $table) {
                $table->uuid('uuid');
                $table->foreign('uuid')->references('uuid')->on('inside_content_alerts')->onDelete('cascade');
                $table->uuid('user_uuid');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            });

            Schema::table(
                'desk_alerts_sent',
                function (Blueprint $table) {
                    $table->index(['uuid', 'user_uuid']);
                }
            );

            Schema::create('desk_alerts_to_send', function (Blueprint $table) {
                $table->uuid('uuid');
                $table->foreign('uuid')->references('uuid')->on('inside_content_alerts')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('desk_alerts_sent');
    }
}
