<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class InstallNewsletters extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('desk_newsletters_sent')) {
            Schema::create('desk_newsletters_sent', function (Blueprint $table) {
                $table->datetime('date_sent')->nullable();
                $table->uuid('user_uuid');
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            });

            Schema::table(
                'desk_newsletters_sent',
                function (Blueprint $table) {
                    $table->index(['user_uuid', 'date_sent']);
                }
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('desk_newsletters_sent');
    }
}
