<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddHiddenNewsTypesField extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $field = [
            'name' => 'news_types',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Type d\'actualités',
                'en' => 'News type',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_types'],
                'cardinality' => 1,
            ],
        ];

        $contentTypes = ['career_infos', 'memorandums'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'news_types', $field);
        }
    }

    public function down(): void
    {
    }
}
