<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCareerInfosFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeDeleteField('node', 'career_infos', 'missions');
        $this->bridge->contentTypeDeleteField('node', 'career_infos', 'profile');

        $fields = [
            'missions_title' => [
                'name' => 'missions_title',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Missions principales (titre)',
                    'en' => 'Principal missions (title)',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'missions' => [
                'name' => 'missions',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Missions principales',
                    'en' => 'Principal missions',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [
                        'rows' => 9,
                        'summary_rows' => 3,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            'profile_title' => [
                'name' => 'profile_title',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Profil (titre)',
                    'en' => 'Profile (title)',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 7,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'profile' => [
                'name' => 'profile',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'required' => true,
                'weight' => 1,
                'title' => [
                    'fr' => 'Profil',
                    'en' => 'Profile',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [
                        'rows' => 9,
                        'summary_rows' => 3,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ];

        foreach ($fields as $key => $field) {
            $this->bridge->contentTypeCreateOrUpdateField('career_infos', $key, $field);
        }
    }

    public function down(): void
    {
    }
}
