<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsForAutomaticTranslation extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $contentTypes = ['news', 'memorandums', 'career_infos', 'tools', 'contacts'];

        $fields = [
            'last_update' => [
                'name' => 'last_update',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Dernière mise à jour',
                    'en' => 'Last update',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            'updated_by' => [
                'type' => BridgeContentType::REFERENCE_FIELD,
                'name' => 'updated_by',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 0,
                'default' => [],
                'title' => [
                    'fr' => 'Mis à jour par',
                    'en' => 'Updated by',
                ],
                'description' => [],
                'settings' => [
                    'cardinality' => -1,
                    'target_type' => 'users',
                ],
                'widget' => [
                    'hidden' => true,
                ],
            ],
        ];

        foreach ($contentTypes as $contentType) {
            foreach ($fields as $key => $field) {
                $bridgeContentType->contentTypeCreateOrUpdateField($contentType, $key, $field);
            }
        }
    }

    public function down(): void
    {
    }
}
