<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddChapoFieldToMemorandumsAndCareerInfos extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $chapo = [
            'name' => 'chapo',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Chapô',
                'en' => 'Headline',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ];

        $contentTypes = ['memorandums', 'career_infos'];

        foreach ($contentTypes as $contentType) {
            $this->bridge->contentTypeCreateOrUpdateField($contentType, 'chapo', $chapo);
        }

        $this->finishUp();
    }

    public function down(): void
    {
    }
}
