<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddRecruitingCompanyFieldToCareerInfos extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->bridge->contentTypeCreateOrUpdateField('career_infos', 'recruiting_company', [
            'name' => 'recruiting_company',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Infos de la société recrutant',
                'en' => 'Recruiting company info',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
        $this->finishUp();
    }

    public function down(): void
    {
    }
}
