<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class NewsMigration extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('news_types', false);
        $this->migrateContent('news_categories', false);
        $this->migrateContent('news', false);

        $this->finishUp();

        $contentMapping = [
            'news_types' => [
                [
                    'title' => 'Soyez vigilant !',
                    'text_color' => '#fe8o8o',
                    'background_color' => 'transparent',
                    'class' => 'desk-siren',
                ],
                [
                    'title' => 'Le saviez-vous ?',
                    'text_color' => '#2cb2b2',
                    'background_color' => 'transparent',
                    'class' => 'desk-lightbulb',
                ],
                [
                    'title' => 'Incontournable',
                    'text_color' => 'transparent',
                    'background_color' => '#ffb585',
                    'class' => 'desk-fire',
                ],
            ],
            'news_categories' => [
                ['title' => 'Hébergement'],
                ['title' => 'Réception - Réservation'],
                ['title' => 'Qualité Clientèle'],
                ['title' => 'Les offres de restauration'],
                ['title' => 'La sécurité alimentaire'],
                ['title' => 'La restauration'],
                ['title' => 'Séminaires'],
                ['title' => 'La Distribution'],
                ['title' => 'Le Revenue Management'],
                ['title' => 'Marketing'],
                ['title' => 'Pricing'],
                ['title' => 'Ventes'],
                ['title' => 'Ressources humaines'],
                ['title' => 'L\'information aux salariés'],
                ['title' => 'Le recrutement'],
                ['title' => 'Université'],
                ['title' => 'Genius'],
                ['title' => 'La comptabilité'],
                ['title' => 'Le contrôle de gestion'],
                ['title' => 'Achats'],
                ['title' => 'Technique'],
                ['title' => 'IT'],
                ['title' => 'Sécurité'],
                ['title' => 'Juridique'],
                ['title' => 'Développement'],
                ['title' => 'Franchise'],
                ['title' => 'Communication interne'],
                ['title' => 'Le Blog'],
                ['title' => 'Evénement'],
                ['title' => 'Gatekeeper'],
            ],
        ];

        $bridge = new BridgeContent();
        foreach ($contentMapping as $contentType => $contents) {
            foreach ($contents as $content) {
                $data = array_merge($content, [
                    'type' => 'node',
                    'bundle' => $contentType,
                    'langcode' => 'fr',
                ]);

                $this->getConsole()->writeln(sprintf('Creating content %s of content type %s', $data['title'], $contentType));

                $bridge->contentInsert($contentType, $data);
            }
        }
    }


    public function down(): void
    {
    }
}
