<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'p_and_p_regions',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'title' => [
            'fr' => 'Régions de P&P',
            'en' => 'P&P regions',
        ],
    ],
    'fields' => [
        [
            'name' => 'p_and_p',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'P&P',
                'en' => 'P&P',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['p_and_p'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'regional_offices',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Région',
                'en' => 'Region',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['regional_offices'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'contact',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Contact P&P',
                'en' => 'P&P contact',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'last_update',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Dernière mise à jour',
                'en' => 'Last update',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'updated_by',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Mis à jour par',
                'en' => 'Updated by',
            ],
            'widget' => [
                'hidden' => true,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => false,
        ],
    ],
];
