<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 0;
return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'contacts',
        'title' => [
            'fr' => 'Contacts',
            'en' => 'Contacts',
        ],
    ],
    'groups' => [
        [
            'group_name' => 'group_visibility_rights',
            'entity_type' => 'node',
            'bundle' => 'contacts',
            'children' => [
                'brands',
                'countries',
                'management_modes',
                'profiles',
            ],
            'weight' => 4,
            'parent_name' => '',
            'format_settings' => [
                'label' => 'Rights of visibility',
                'description' => '',
                'required_fields' => true,
                'id' => '',
                'classes' => '',
            ],
            'label' => 'Rights of visibility',
            'format_type' => 'fieldset',
        ],
        [
            'group_name' => 'group_advanced_options',
            'entity_type' => 'node',
            'bundle' => 'contacts',
            'children' => [
                'langcode',
                'created',
                'uid',
            ],
            'weight' => 5,
            'parent_name' => '',
            'format_settings' => [
                'label' => 'Advanced options',
                'description' => '',
                'required_fields' => true,
                'id' => '',
                'classes' => '',
            ],
            'label' => 'Advanced options',
            'format_type' => 'fieldset',
        ],
        [
            'group_name' => 'group_publication_workflow',
            'entity_type' => 'node',
            'bundle' => 'contacts',
            'children' => [
                'contacts_categories',
                'status'
            ],
            'weight' => 6,
            'parent_name' => '',
            'format_settings' => [
                'label' => 'Publication Workflow',
                'description' => '',
                'required_fields' => true,
                'id' => '',
                'classes' => '',
            ],
            'label' => 'Publication Workflow',
            'format_type' => 'fieldset',
        ],

    ],
    'fields' => [
        [
            'name' => 'emails',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Emails',
                'en' => 'Emails',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'phones',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Téléphones',
                'en' => 'Phones',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'text',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Texte',
                'en' => 'Text',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
                'weight' => 14,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'brands',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 5,
            'title' => [
                'fr' => 'Marques',
                'en' => 'Brands',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['brands'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'countries',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 6,
            'title' => [
                'fr' => 'Pays',
                'en' => 'Countries',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['countries'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'management_modes',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 7,
            'title' => [
                'fr' => 'Modes de gestion',
                'en' => 'Management modes',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['management_modes'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'profiles',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'selectable_all' => true,
            'required' => true,
            'weight' => 8,
            'title' => [
                'fr' => 'Profils',
                'en' => 'Profiles',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
                'group' => 'group_visibility_rights',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['profiles'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'contacts_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Categorie d\'outils',
                'en' => 'Contacts category',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 10,
                'group' => 'group_publication_workflow',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['contacts_categories'],
                'cardinality' => 1,
            ],
        ],
    ],
];
