<?php

return [
    'custom_notifications' => function (&$data, $model, $notificationType, $action) {
        if ($notificationType !== 'email') {
            return;
        }

        switch ($action) {
            case 'edit':
                if (! array_key_exists('steps', $data)) {
                    return;
                }

                $data['extra']['mail']['text'] = 'notifications.mail.workflow.approval.text';
                break;
            case 'accept':
                if ($model->author === $data['to']) {
                    $data['extra']['mail']['text'] = 'notifications.mail.workflow.accepted.author.text';
                } else {
                    $data['extra']['mail']['text'] = 'notifications.mail.workflow.accepted.text';
                }
                break;
        }
    },
];
