<?php

use Illuminate\Console\Scheduling\Schedule;
use Inside\DESK\Jobs\ComputeNewslettersStatistics;

return [
    'schedule' => [
        'newsletters' => fn (Schedule $scheduler) => $scheduler
            ->command('desk:send-newsletters', ['--batchsize', 300])
            ->timezone('Europe/Paris')
            ->tuesdays()
            ->everyFifteenMinutes()
            ->between('13:30', '20:00'),
        'newsletters-test' => fn (Schedule $scheduler) => $scheduler
            ->command('desk:send-newsletters', ['--test'])
            ->tuesdays()
            ->at('8:30')
            ->timezone('Europe/Paris'),
        'alerts' => fn (Schedule $scheduler) => $scheduler
            ->command('desk:send-alerts', ['--batchsize', 300])
            ->everyTenMinutes(),
        'stats-export' => function (Schedule $scheduler) {
            $firstDay = date('Y-m-01', time());
            $firstDay = date('Y-m-01', (int) strtotime($firstDay.' -1 day'));
            $lastDay = date('Y-m-t', (int) strtotime($firstDay));
            $scheduler->command(sprintf('desk:user:infos:export %s %s --notify', $firstDay, $lastDay))->monthlyOn(2, '13:00')->timezone('Europe/Paris');
        },
        'newsletters-statistics' => fn (Schedule $scheduler) => $scheduler
            ->job(new ComputeNewslettersStatistics())
            ->daily()
            ->at('2:30'),
        'retry-failed-jobs' => fn (Schedule $scheduler) => $scheduler
            ->command('lhg:queue:retry-failed-mysql-jobs')
            ->everyTenMinutes(),
        'fix-missing-form-answers' => fn (Schedule $scheduler) => $scheduler
            ->command('desk:fix-missing-form-answers')
            ->daily()
            ->at('1:00'),
        'fix-missing-comments' => fn (Schedule $scheduler) => $scheduler
            ->command('desk:fix-missing-comments')
            ->daily()
            ->at('1:30'),
    ],
];
