<?php

use Illuminate\Support\Arr;
use Inside\Content\Facades\ContentHelper;

if (! function_exists('clean_content_types')) {
    function clean_content_types(array $content): array
    {
        return Arr::except(
            $content,
            config('external_api.inside_external_api_fields_content_remove')
        );
    }
}

return [
    'inside_external_api_enabled' => env('INSIDE_EXTERNAL_API_ENABLED', true),
    'inside_external_api_bypass_auth_external' => env('INSIDE_EXTERNAL_API_AUTH_BYPASS', true),
    'inside_external_api_pagination_limit' => 50,
    'inside_external_api_fields' => [
        'brands' => [
            'uuid',
            'langcode',
            'title',
            'code',
            'updated_at',
        ],
        'profiles' => [
            'uuid',
            'langcode',
            'title',
            'code',
            'updated_at',
        ],
        'management_modes' => [
            'uuid',
            'langcode',
            'title',
            'code',
            'updated_at',
        ],
        'news' => [
            'uuid',
            'langcode',
            'title',
            'news_categories'  => ['title'],
            'chapo',
            'image',
            'content',
            'brands' => ['title', 'code'],
            'management_modes' => ['title', 'code'],
            'countries' => ['title', 'code'],
            'profiles' => ['title', 'code'],
            'regional_office_types' => ['title'],
            'news_types' => ['title'],
            'users' => ['email', 'firstname', 'lastname'],
            'comments' => ['body'],
            'last_update',
            'updated_at',
            'published_at',
            'slug',
        ],
        'memorandums' => [
            'uuid',
            'langcode',
            'title',
            'chapo',
            'content',
            'cc',
            'from',
            'function',
            'to',
            'brand' => ['title', 'code'],
            'brands' => ['title', 'code'],
            'countries' => ['title', 'code'],
            'management_modes' => ['title', 'code'],
            'profiles' => ['title', 'code'],
            'regional_office_types' => ['title'],
            'news_categories'  => ['title'],
            'news_types' => ['title'],
            'contact' => ['email', 'firstname', 'lastname'],
            'last_update',
            'updated_at',
            'published_at',
            'slug',
        ]
    ],
    'inside_external_api_fields_content_remove' => [
        'uuid',
        'created_at',
        'updated_at',
        'reactions',
        'published_at',
        'statistics',
        'unique_views',
        'total_views',
        'archived',
        'description',
    ],
    'inside_external_api_filters' => function ($query, $request) {
        $query->where('status', 1);
        if ($request->has('langcode')) {
            $query->where('langcode', $request->get('langcode'));
        }
        if ($request->has('updated_at')) {
            $timestamp = $request->get('updated_at');
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', $timestamp));
        }

        return $query;
    },
    'inside_external_api_transform' => function ($result) {
        $result->transform(function ($data) {
            if (isset($data['content'])) {
                $data['content'] = collect($data['content'])->transform(
                    fn ($content) => isset($content['content']) ?
                  collect($content['content'])
                    ->transform(fn ($content) => clean_content_types($content))
                    ->filter()
                    ->toArray()
                  : clean_content_types($content)
                )->filter()->toArray();
            }

            if (! isset($data['content'])) {
                $data['content'] = [];
            }

            return $data;
        })->toArray();

        return $result;
    },
];
