import { http } from '@inside-library/helpers/Http'

export default {
  locations: {
    add: () => ({
      name: 'HomePage'
    })
  },
  services: {
    add: () => ({
      name: 'HomePage'
    })
  },
  skills: {
    add: () => ({
      name: 'HomePage'
    })
  },
  directions: {
    add: () => ({
      name: 'HomePage'
    })
  },
  companies: {
    add: () => ({
      name: 'HomePage'
    })
  },
  languages: {
    add: () => ({
      name: 'HomePage'
    })
  },
  cardsLinks: {
    add: () => ({
      name: 'HomePage'
    })
  },
  jobsSpaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  jobsGroupingPages: {
    fields: [{ jobs_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.jobs_spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.jobs_spaces.slug[0] }
    })
  },
  jobsPages: {
    fields: ['uuid', { jobs_grouping_pages: [{ jobs_spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data?.jobs_grouping_pages?.jobs_spaces?.slug?.[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data?.jobs_grouping_pages?.jobs_spaces?.slug?.[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: jobsGroupingPage } = await http.get('content/jobs_pages', {
        fields: ['uuid', { jobs_grouping_pages: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: jobsSpace } = await http.get(
        'content/jobs_grouping_pages',
        {
          fields: ['uuid', { jobs_spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'uuid:eq': jobsGroupingPage[0].jobs_grouping_pages.uuid }
        }
      )

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: jobsSpace?.[0]?.jobs_spaces?.slug?.[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  },
  catalog: {
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'features',
          'fetch',
          {
            item: data,
            contentType: data.contentType
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
    })
  },
  rooms: {
    add: ({ data }) => ({
      name: 'AgendaPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'AgendaListingPage'
    })
  }
}
