import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import JobModal from '../components/jobs/JobModal'
import CatalogModal from '../components/catalog/DefaultModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('job-modal', JobModal)
    app.component('default-modal', CatalogModal)
  })
}
