export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'mobile_phone',
      'image',
      'function',
      { services: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] },
      'linkedin',
      'twitter',
      'languages',
      'skills',
      {
        manager: ['uuid', 'firstname', 'lastname', 'function', 'image', 'phone']
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  jobs_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'link',
      'button_link',
      'content',
      { contracts_types: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] }
    ]
  },
  catalog: {
    modalFields: [
      'features',
      'title',
      'presentation',
      'image',
      'last_clients',
      'specificities',
      'link_mockup',
      'published_at',
      { authors: ['uuid', 'lastname', 'firstname'] }
    ],
    specificPage: {
      fr: 'catalogue'
    },
    onDelete: 'catalogue'
  },
  vacations: {
    extendedUrl: ['uuid'],
    editionDisabled: true,
    modalFields: [
      'title',
      'uuid',
      'date',
      'end_date',
      'comment',
      'start_timeframes',
      'end_timeframes',
      { authors: ['uuid', 'image', 'firstname', 'lastname'] },
      { validator: ['uuid', 'image', 'firstname', 'lastname'] },
      { vacations_status: ['uuid', 'color', 'title', 'value'] }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'created_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  }
}
