import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'TeamsListingPage',
    component: () => import('@inside-teams/components/pages/TeamsListingPage')
  },
  {
    name: 'AgendaListingPage',
    meta: { disabled: false }
  },
  {
    name: 'AgendaPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'CatalogPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FullWidthPage',
    meta: { disabled: false }
  },
  {
    name: 'WallsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'WallPage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsArtificialIntelligencePage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminStatisticsGeneralPage',
    meta: { admin: true, display: true, disabled: true }
  },
  {
    name: 'AdminStatisticsDetailedPage',
    meta: { admin: true, display: true, disabled: false }
  }
]
