<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class AddEntrepriseFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (Schema::hasModel('users') && Schema::hasField('users', 'companies')) {
            $bridge->contentTypeDeleteField(
                entityType: 'user',
                type: 'user',
                fieldName: 'companies'
            );
        }

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'entreprise',
            options: [
                'name' => 'entreprise',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => true,
                'weight' => 14,
                'title' => [
                    'fr' => 'Entreprise',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [],
                    'weight' => 14,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: 14
        );
    }
}
