<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddNewFieldToCardsLinks extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('cards_links', 'is_featured', [
            'name' => 'is_featured',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Mis en avant',
            ],
            'description' => [
                'fr' => 'Faites remonter la carte en haut sur la page d\'accueil',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'group' => 'group_advanced_options',
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);
    }
}
