<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateAdsContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasModel('offers')) {
            $this->getBridge()?->contentTypeDelete('offers');
        }

        if (Schema::hasModel('offers_categories')) {
            $this->getBridge()?->contentTypeDelete('offers_categories');
        }

        $this->migrateContent('ads_categories');
        $this->migrateContent('ads');
        $this->finishUp();
    }
}
