<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Migrations\CreateContentTypes;

final class UpdateUsersIsHiddenInDirectoryField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'is_hidden_in_directory', [
            'searchable' => true,
            'search_result_field' => true,
            'searchable_filter' => true,
        ]);

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild');
        $this->finishUp();
    }
}
