<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\JobsSpaces;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ChangeJobsSpacesDescriptionField extends Migration
{
    public function up(): void
    {
        $spaces = JobsSpaces::query()->get();

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'jobs_spaces', 'description');

        $bridge->contentTypeCreateOrUpdateField('jobs_spaces', 'description', [
            'name' => 'description',
            'translatable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Descriptif'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridgeContent = new BridgeContent();

        foreach ($spaces as $space) {
            $bridgeContent->contentUpdate('jobs_spaces', [
                'uuid' => $space->uuid,
                'description' => strip_tags($space->description)
            ]);
        }
    }
}
