<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddHideInDirectoryFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'is_hidden_in_directory', [
            'name' => 'is_hidden_in_directory',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Ne pas afficher dans l’annuaire',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);
    }
}
