<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateSkillsField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'skills');

        $bridge->contentTypeCreateOrUpdateField('users', 'skills', [
            'name' => 'skills',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 14,
            'title' => [
                'fr' => 'Compétences',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 14,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
    }
}
