<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema;

class RemoveGroups extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasContentType('groups_posts')) {
            $this->bridge->contentTypeDelete('groups_posts');
        }
        if (Schema::hasContentType('groups_folders')) {
            $this->bridge->contentTypeDelete('groups_folders');
        }
        if (Schema::hasContentType('groups_documents')) {
            $this->bridge->contentTypeDelete('groups_documents');
        }
        if (Schema::hasContentType('groups')) {
            $this->bridge->contentTypeDelete('groups');
        }

        $tables = [
            'group_activities',
            'group_members',
            'group_posts',
            'groups',
        ];

        foreach ($tables as $table) {
            \Illuminate\Support\Facades\Schema::drop($table);
        }

        \Inside\Notify\Models\NotificationType::query()->where('type', 'group')->delete();

        $migrations = [
            '2019_09_04_000000_install_contents',
            '2020_07_23_000000_fix_group_like_notifications',
            '2020_07_24_000000_fix_web_group_notifications',
            '2020_09_18_000000_migrate_notification_to_role_notification',
            '2020_09_25_000000_change_url_member_pending_group_notifications',
            '2020_11_10_000000_add_role_to_notifications',
            '2020_12_21_000000_edit_pending_members_label',
            '2021_05_10_000000_new_group_system',
            '2021_05_10_000001_synchronize_to_new_group_system',
            '2021_07_20_000000_fix_user_joined_group_notifications',
        ];

        DB::table('migrations')->whereIn('migration', $migrations)->delete();
    }

    public function down(): void
    {
    }
}
