<?php

declare(strict_types=1);

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tabs',
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Onglet',
        ],
    ],
    'fields' => [
        [
            'name' => 'icon',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Icone',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_ICON_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tabs_spaces',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Espace à onglets',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle le regroupement doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tabs_spaces'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
