<?php

use Google\Service\PeopleService;
use Google\Service\PeopleService\Photo;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Companies;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Users;
use Inside\Facades\Http;

return [
    'sync_attributes' => [
        'mail' => 'getPrimaryEmail',
        'name' => 'getPrimaryEmail',
        'firstname' => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();
            return $name['givenName'];
        },
        'lastname' => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['familyName'];
        },
        'birthday' => function (\Google_Service_Directory_User $user, $bridge) {
            $custom = $user->getCustomSchemas();
            if ($custom['Date_de_naissance']) {
                return date('Y-m-d H:i:s', strtotime($custom['Date_de_naissance']['Date_de_naissance']));
            }
        },
        'entreprise' => function (\Google_Service_Directory_User $user, $bridge) {
            $custom = $user->getCustomSchemas();

            $company = Companies::query()->where('title', $custom['Agence']['Agence'])->first();

            return $company->title;
        },
        'phone' => function (\Google_Service_Directory_User $user, $bridge) {
            $phones = $user->getPhones();
            foreach ($phones as $phone) {
                if ($phone['type'] === "work") {
                    return $phone['value'];
                }
            }
        },
        'function' => function (\Google_Service_Directory_User $user, $bridge) {
            $organizations = $user->getOrganizations();
            $maecia = $organizations[0];
            if ($maecia) {
                return $maecia['title'];
            }
        },
        'image' => function (\Google_Service_Directory_User $user, $bridge, $service) {
            $thumbnailPhotoUrl = $user->getThumbnailPhotoUrl();
            if ($thumbnailPhotoUrl) {
                /**
                 * @var string $thumbnailPhotoUrl
                 */
                $thumbnailPhotoUrl = preg_replace('/=.+$/', '', $thumbnailPhotoUrl);
                $fileName = basename($thumbnailPhotoUrl);

                $response = Http::get($thumbnailPhotoUrl);
                if ($response->successful()) {
                    $contentType = $response->header('Content-Type');

                    $chunkId = \Inside\Support\Str::random(32);
                    $chunksPath = cms_base_path(env('APP_STORAGE_PATH', storage_path()) . '/chunks/' . $chunkId);
                    File::makeDirectory($chunksPath);

                    $extension = Str::after($contentType, 'image/');
                    $name = $user->getName();
                    $userName = $name['givenName'] . '-' . $name['familyName'];

                    $profileFilename = sprintf("%s.%s", $userName, $extension);
                    $filePath = "chunks/" . $chunkId . '/' . $profileFilename;

                    Storage::disk('local')->put($filePath, $response->body());
                    $thumbnailPhotoUrl = $filePath;
                }
            }
            return $thumbnailPhotoUrl;
        },
        'services' => function (\Google_Service_Directory_User $user, $bridge) {
            $organizations = $user->getOrganizations();
            $maecia = $organizations[0];
            if ($maecia) {
                $service = Services::query()->where('title', $maecia['department'])->first();
                if ($service) {
                    return $service->uuid;
                }
            }
        },
    ],
];
