<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Content;
use Inside\Content\Facades\ContentBlueprints;
use Illuminate\Support\Facades\Artisan;

class CreateCustomPageAlphabet extends Migration
{
    public function up(): void
    {
        ContentBlueprints::generateContent('alphabet_books_categories');
        ContentBlueprints::generateContent('alphabet_books');
        ContentBlueprints::generateContent('full_width_pages');

        Artisan::call('db:seed', [
            '--class' => 'Inside\\Content\\Seeders\\AlphabetCategoriesSeeder',
            '--force' => true,
        ]);

        $bridge = new BridgeContent();

        $alphabetBooksLanguages = collect([
            'fr' => 'Abécédaire',
            'en' => 'Alphabet book',
            'es' => 'Libro de alfabeto',
            'pt' => 'Livro de alfabeto',
            'de' => 'Alphabetbuch',
            'nl' => 'Alfabetboek',
        ])->only(list_languages());

        $parent_uuid_host = null;

        $alphabetBooksLanguages->each(function ($title, $lang) use ($bridge, $parent_uuid_host) {
            $alphabetBooksCustomPageExists = type_to_class('custom')::query()->where('custom_slug', 'alphabet_books')->where('langcode', $lang)->exists();

            if (is_null($parent_uuid_host) && $alphabetBooksCustomPageExists instanceof Content) {
                $parent_uuid_host = $alphabetBooksCustomPageExists->uuid;
            }

            if ($alphabetBooksCustomPageExists) {
                return;
            }

            $data = collect([
                'langcode' => $lang,
                'title' => $title,
                'custom_slug' => 'alphabet_books',
                'redirection_page' => 'AlphabetBooksListingPage',
                'uuid_host' => $parent_uuid_host,
            ])->when(is_null($parent_uuid_host), fn ($data) => $data->forget('uuid_host'));

            $uuid_host = $bridge->contentInsert(
                type: 'custom',
                data: $data->toArray(),
            );

            if (is_null($parent_uuid_host)) {
                $firstCustomPage = $uuid_host;
            }

            Log::info("Custom page 'alphabet_books' inserted for language: $lang");
        });
    }
}
