<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateJobsSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField('jobs_spaces', 'news_categories', [
            'name' => 'news_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Catégorie d\'actualité',
            ],
            'description' => [
                'fr' => 'Selectionnez la catégorie d\'actualité qui remonteront dans un carrousel dans le contenu central de l\'espace',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 6,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news_categories'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);
    }
}
