<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateToolsAndJobsSpacesTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->updateFieldOptions('tools', 'content', [
            'required' => false
        ]);

        $fieldsToRemove = ['news_categories', 'events_categories', 'folders'];
        foreach ($fieldsToRemove as $field) {
            $bridge->contentTypeDeleteField('node', 'jobs_spaces', $field);
        }
    }
}
