<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Lang;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class UpdateUsersTypeFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('languages');
        $this->migrateContent('skills');

        $this->finishUp();

        Artisan::call("models:rebuild");

        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'linkedin',
            [
                'name' => 'linkedin',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Linkedin',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'twitter',
            [
                'name' => 'twitter',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Twitter',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'manager',
            [
                'name' => 'manager',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Manager',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [
                        'match_operator' => 'CONTAINS',
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 12,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => 1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'languages',
            [
                'name' => 'languages',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 13,
                'title' => [
                    'fr' => 'Langues parlées',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [
                        'match_operator' => 'CONTAINS',
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 13,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'languages',
                    'cardinality' => -1,
                ],
            ],
        );

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'skills',
            [
                'name' => 'skills',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 14,
                'title' => [
                    'fr' => 'Compétences',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 14,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'skills',
                    'cardinality' => -1,
                ],
            ],
        );
    }
}
