<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateProjectContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile');
        $bridge->contentTypeCreateOrUpdateField('dms_link', 'folders', [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Dossier parent',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);

        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('locations');
        $this->migrateContent('services');
        $this->migrateContent('companies');
        $this->migrateContent('users');
        $this->migrateContent('custom');
        $this->migrateContent('pages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('directions');
        $this->migrateContent('contracts');
        $this->migrateContent('job_offers');
        $this->migrateContent('offers_categories');
        $this->migrateContent('offers');

        $this->finishUp();
    }
}
