<?php

declare(strict_types=1);
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Companies;
use Inside\Content\Models\Contents\Services;

return [
    'manual' => [
      'disable' => false
    ],
    'files' => [
        'demo' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/import.xlsx'),
            'fields' => [
                'mail' => 'email',
                'name' => 'email',
                'firstname' => 'prenom',
                'lastname' => 'nom',
                'birthday' => fn ($record) => \Carbon\Carbon::parse($record['birthday'])->format('Y-m-d H:i:s'),
                'companies' => fn (array $record) => $record['companies'],
                'phone' => 'phone',
                'function' => 'fonction',
                'services' => function (array $record) {
                    return reference('services')
                        ->from($record['department'])
                        ->first();
                }
            ],
            'original_fields' => [
                'email' => 'mail',
                'prenom' => 'firstname',
                'nom'  => 'lastname',
                'birthday' => 'date',
                'companies' => 'company',
                'phone' => 'phone',
                'fonction' => 'function',
                'department' => ''
            ],
        ],
    ],
];
