export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    path: '/annuaire-des-utilisateurs',
    name: 'UsersDirectoryPage',
    component: () => import('../pages/directories/UsersDirectoryPage')
  },
  {
    path: '/annuaire-des-partenaires',
    name: 'PartnersDirectoryPage',
    component: () => import('../pages/directories/PartnersDirectoryPage')
  },
  {
    name: 'GedPage',
    path: '/delphateque',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    path: '/management-projets',
    name: 'SpacePage',
    component: () => import('../pages/spaces/SpacePage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      extraFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'AgendaListingPage',
    component: () => import('../pages/agenda/AgendaListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'AgendaPage',
    component: () => import('../pages/agenda/AgendaPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
