export default {
  groupingPages: {
    add: () => ({ name: 'SpacePage' }),
    delete: () => ({ name: 'SpacePage' })
  },
  projectManagementPages: {
    extends: 'groupingPages'
  },
  rooms: {
    add: () => ({ name: 'AgendaListingPage' }),
    delete: () => ({ name: 'AgendaListingPage' })
  },
  externalPartners: {
    add: () => ({ name: 'PartnersDirectoryPage' }),
    delete: () => ({ name: 'PartnersDirectoryPage' }),
    globalSearch: ({ data, vm }) => ({
      routeAs: 'add',
      action: vm.triggerModal(
        'external-partner-modal',
        'fetch',
        {
          item: data,
          contentType: data.content_type
        },
        {
          layout: 'right',
          transition: 'fadeInLeft',
          size: 'm',
          useUrlParams: true
        }
      )
    })
  },
  partnersCompanies: {
    extends: 'externalPartners'
  },
  partnersCategories: {
    extends: 'externalPartners'
  },
  partnersSpecialities: {
    extends: 'externalPartners'
  },
  functions: {
    add: () => ({ name: 'UsersDirectoryPage' }),
    delete: () => ({ name: 'UsersDirectoryPage' })
  }
}
