import Google from '@inside-auth/components/login/extra-component/Google'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  'inside-agenda': {
    rootRoute: {
      fr: 'reservations'
    }
  },
  'inside-auth': {
    extraComponent: {
      is: Google,
      link: `${origin}/google/login`
    }
  },
  'inside-users': {
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
