<?php

namespace Inside\DELP\Providers;

use Illuminate\Container\Container;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Inside\DELP\Console\ImportExternalPartnersCommand;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * DELP Service provider.
 *
 * @category Class
 * @package  Inside\DELP\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->app->singleton(
            'command.external.partners.import',
            function (Container $app) {
                return new ImportExternalPartnersCommand();
            }
        );

        $this->commands('command.external.partners.import');

        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/google.php', 'google');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
