<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateProjectContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile');

        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('functions');
        $this->migrateContent('users');
        $this->migrateContent('custom');
        $this->migrateContent('pages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('blocks');
        $this->migrateContent('social_networks');
        $this->migrateContent('grouping_pages');
        $this->migrateContent('project_management_pages');
        $this->migrateContent('partners_categories');
        $this->migrateContent('partners_specialities');
        $this->migrateContent('partners_companies');
        $this->migrateContent('external_partners');

        $this->finishUp();
    }
}
