<?php

use Google\Service\PeopleService;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Agency;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Users;

return [
    'postfilter'    => function ($users) {
        return $users->reject(function ($user) {
            return (bool) $user->suspended;
        });
    },
    'sync_attributes' => [
        'mail'      => 'getPrimaryEmail',
        'name'      => 'getPrimaryEmail',
        'firstname' => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['givenName'];
        },
        'lastname'  => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['familyName'];
        },
        'birthday'  => function (\Google_Service_Directory_User $user, $bridge) {
            $custom = $user->getCustomSchemas();
            if ($custom['Date_de_naissance']) {
                return date('Y-m-d H:i:s', strtotime($custom['Date_de_naissance']['Date_de_naissance']));
            }
        },

        'phone'     => function (\Google_Service_Directory_User $user, $bridge) {
            $custom = $user->getCustomSchemas();
            if ($custom['Tlphone_pro']) {
                return $custom['Tlphone_pro']['Tlphone_pro'];
            }
        },
        'functions'  => function (\Google_Service_Directory_User $user, $bridge) {
            $uuids = [];
            $custom = $user->getCustomSchemas();
            if ($custom['Expertise']) {
                $entity = call_user_func(type_to_class('functions').'::query')
                    ->where('title', $custom['Expertise']['Expertise'])
                    ->first();

                if ($entity) {
                    $uuid = $entity->uuid;
                } else {
                    $uuid = $bridge->contentInsert(
                        'functions',
                        [
                            'type' => 'node',
                            'bundle' => 'functions',
                            'title' => $custom['Expertise']['Expertise'],
                            'uid' => 1,
                        ]
                    );
                }

                $uuids[] = $uuid;
            }

            return $uuids ?: null;
        },
    ],
];
